/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.RoutingBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.ArrayList;

public class RouteEntryBean
extends PanelBean
implements SettingsConstants {
    private String m_sLanList;
    private ValueDescriptor[] m_cdLanList;
    private String[] m_sEntryPositionSelection;
    private String[] m_sRouteTypeSelection;
    private String m_sDestination;
    private String m_sGateway;
    private String m_sSubnetMask;
    private RoutingBean routingBean;
    private String button;
    private String[] lanList;
    private ArrayList rowData;
    private String[] routeTypes = new String[]{"Net", "Host", "Default"};
    private String[] buttonTypes = new String[]{"netButton", "hostButton", "defaultButton"};
    private static final String TRACE_MASKT = "XSETREBT";
    private static final String TRACE_MASKF = "XSETREBF";
    private static final String TRACE_MASKD = "XSETREBD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "RouteEntryBean");
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);

    public RouteEntryBean(ArrayList dataInput, String action, String[] lanAdapterList) {
        Trace.trace(TRACE_MASKT, "-> RouteEntryBean constructor");
        this.rowData = dataInput;
        this.button = action;
        Trace.trace(TRACE_MASKT, "action = " + this.button);
        this.lanList = new String[lanAdapterList.length + 1];
        this.lanList[0] = new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "RouteEntryPanelPulldown.TEXT").toString();
        int i = 1;
        while (i < lanAdapterList.length + 1) {
            this.lanList[i] = lanAdapterList[i - 1];
            Trace.trace(TRACE_MASKT, "lanList[" + i + "] = " + this.lanList[i]);
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- RouteEntryBean constructor");
    }

    public String[] getEntryPositionSelection() {
        return this.m_sEntryPositionSelection;
    }

    public void setEntryPositionSelection(String[] selected) throws IllegalUserDataException {
        this.m_sEntryPositionSelection = selected;
    }

    public String[] getRouteTypeSelection() {
        return this.m_sRouteTypeSelection;
    }

    public void setRouteTypeSelection(String[] selected) throws IllegalUserDataException {
        this.m_sRouteTypeSelection = selected;
    }

    public String getDestination() {
        return this.m_sDestination;
    }

    public void setDestination(String s) throws IllegalUserDataException {
        if (!NetworkInfo.isValidIPAddr(s)) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDestination = s;
    }

    public String getGateway() {
        return this.m_sGateway;
    }

    public void setGateway(String s) throws IllegalUserDataException {
        if (!NetworkInfo.isValidIPAddr(s)) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sGateway = s;
    }

    public String getSubnetMask() {
        return this.m_sSubnetMask;
    }

    public void setSubnetMask(String s) throws IllegalUserDataException {
        if (!NetworkInfo.isValidIPAddr(s)) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sSubnetMask = s;
    }

    public String getLanList() {
        return this.m_sLanList;
    }

    public void setLanList(String s) throws IllegalUserDataException {
        this.m_sLanList = s;
    }

    public ValueDescriptor[] getLanListList() {
        return this.m_cdLanList;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void prepare() {
        this.m_cdLanList = new ValueDescriptor[this.lanList.length];
        int i = 0;
        while (i < this.lanList.length) {
            this.m_cdLanList[i] = new ValueDescriptor(this.lanList[i], this.lanList[i]);
            Trace.trace(TRACE_MASKT, "m_cdLanList[" + i + "] = " + this.lanList[i]);
            ++i;
        }
    }

    public void load() {
        this.m_sLanList = "";
        this.m_cdLanList = new ValueDescriptor[0];
        Trace.trace(TRACE_MASKT, "-> RouteEntryBean.load()");
        this.setEntryPositionSelection(new String[]{"afterButton"});
        Trace.trace(TRACE_MASKT, "getEntryPositionSelection = " + this.getEntryPositionSelection()[0]);
        if (this.button.equals("changeButton")) {
            String buttonType = this.buttonTypes[2];
            int i = 0;
            while (i < 3) {
                if (((String)this.rowData.get(0)).equalsIgnoreCase(this.routeTypes[i])) {
                    buttonType = this.buttonTypes[i];
                }
                ++i;
            }
            this.setRouteTypeSelection(new String[]{buttonType});
            Trace.trace(TRACE_MASKT, "getRouteTypeSelection = " + this.getRouteTypeSelection()[0]);
            this.m_sDestination = (String)this.rowData.get(1);
            this.m_sGateway = (String)this.rowData.get(2);
            this.m_sSubnetMask = (String)this.rowData.get(3);
            this.m_sLanList = (String)this.rowData.get(4);
        } else {
            String buttonType = this.buttonTypes[2];
            this.setRouteTypeSelection(new String[]{buttonType});
            this.m_sDestination = "";
            this.m_sGateway = "";
            this.m_sSubnetMask = "";
            this.m_sLanList = "";
        }
        Trace.trace(TRACE_MASKT, "<- RouteEntryBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> RouteEntryBean.panelAction()  " + command);
        Object uiExc = null;
        try {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            this.rowData = new ArrayList();
            String entryPosition = this.getEntryPositionSelection()[0];
            Trace.trace(TRACE_MASKT, "getEntryPositionSelection = " + this.getEntryPositionSelection()[0]);
            this.rowData.add(entryPosition);
            String buttonType = this.getRouteTypeSelection()[0];
            int i = 0;
            while (i < 3) {
                if (buttonType.equals(this.buttonTypes[i])) {
                    System.out.println("buttontype = " + this.routeTypes[i]);
                    this.rowData.add(this.routeTypes[i]);
                }
                ++i;
            }
            this.rowData.add(this.m_sDestination);
            this.rowData.add(this.m_sGateway);
            this.rowData.add(this.m_sSubnetMask);
            this.rowData.add(this.m_sLanList);
            PanelTaskletRequest request = new PanelTaskletRequest("routeentrypanel");
            if (command.endsWith("routeOkButton")) {
                Trace.trace(TRACE_MASKT, "ROUTEOK_BUTTON pressed!");
                request.setData("panel", "routeentrypanel");
                request.setData("action", "popupdone");
                request.setData("data", this.rowData);
                this.postTaskletRequest(request);
            } else if (command.equals("routeCancelButton") || event.getActionCommand().equals("CANCEL")) {
                Trace.trace(TRACE_MASKT, "ROUTECANCEL_BUTTON pressed!");
                this.dispose();
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 16, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- RouteEntryBean.panelAction()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> RouteEntryBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "EntryPositionGroup");
        this.userTaskManager.storeElement(this.getMountPrefix() + "RouteTypeGroup");
        this.userTaskManager.storeElement(this.getMountPrefix() + "destinationField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "gatewayField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "subnetMaskField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "lanList");
        Trace.trace(TRACE_MASKT, "<- RouteEntryBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> RouteEntryBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "EntryPositionGroup");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "RouteTypeGroup");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "destinationField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "gatewayField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "subnetMaskField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "lanList");
        Trace.trace(TRACE_MASKT, "<- RouteEntryBean.refreshMyElements()");
    }
}

